clear all;
close all;

cm = [1]; %Cloning Methods
L = 80;
lognc = 6;

tvalues=[3,4];
reps=[1,1];
numvals=[11,11];
scale=[1,1];
intervals=50./(numvals-1);
colours={'k',[0.2 0.6 0.8]};
markers={'kx','ko'};
msize=[16,10];

for j=1:size(tvalues,2)
kave=zeros(1,numvals(j));
sLLarray=zeros(1,numvals(j));
for n=1:size(cm,2)
for m = 0:numvals(j)-1
seed = 0;
logt=tvalues(j);
dt = 10;
sLL = m*intervals(j);

filename=sprintf('0,K,%d,%d,%d,%0.1f.mat',logt,lognc,L,sLL);
load(filename);

sLLarray(m+1) = sLL;
kave(m+1) = mean(K)/scale(j);
end
end

hold on,plot(sLLarray,kave,markers{j},'MarkerFaceColor',colours{j},'MarkerSize',msize(j),'LineWidth',1.8);
end

load('K.mat');
hold on,plot(K(:,2),K(:,1),'k-','LineWidth',3.1);

xlim([0,50]);
ylim([0,0.6]);

set(gca, 'FontSize', 32);
set(gca,'linewidth',2);
xlabel('$\lambda$','FontSize',24,'interpreter','latex');
yname = '$\hat{k}(\lambda)_{n_c,t_{obs}}$';
ylabel(yname,'FontSize',26,'interpreter','latex');
set(gca,'XTick', [0,20,40]);
set(gca,'YTick', [0,0.2,0.4]);

legend({'$t_{obs}=10^3$','$t_{obs}=10^4$','Theory'},'FontSize',20,'interpreter','latex');
legend('Location','southwest');
legend('boxoff');
box off;

set(gcf,'units','points','position',[10,10,400,300]);
set(gca, 'FontSize',24);
set(gca,'linewidth',2);

plotname = sprintf('TConv.png');
saveas(gcf,plotname);